* THIS DO-FILE IS FOR THE CROSS-COUNTRY ANALYSES
* IT CREATES OUTPUT FOR TABLE 1 AND APPENDIX TABLES B1, B2, B3, AND B4.
* Stata needs the ado file x_ols2.ado (a slight modification of the ado file x_ols.ado programmed by Jean-Pierre Dube)
* to calculate Conley standard errors based on genetic distance

use data\CountryData.dta, clear


*_______________________________________________________________________________
*	Table 1: Cousin Marriage and Democracy: Cross-country Evidence
*			(with Conley standard errors based on genetic distance)

gen cutoff1=.01 //define cutoff for Conley based on genetic distance
gen cutoff2=.01
gen constant=1

* Table 1, Panel 1 (cousin marriage preference), Panel 2 (cousin-term differentiation), Panel 3 (log % cousin marriage)
local y pol_Democracy_1996_2015
local a nu_rugged ag_distcr du_caloricsui ag_abslat

foreach v of var CousinMarriagePref CousinTermDiff bit_consang_ln { 

preserve
keep if `y'!=. & `v'!=.
reg `y' `v' , r
local r2_x = e(r2)
x_ols2 gendist_coord1 gendist_coord2 cutoff1 cutoff2 `y' `v' constant, coord(2) xreg(2)
ereturn post beta cov_dep
quiet eststo: ereturn display
estadd scalar r2 = `r2_x'
drop epsilon window dis1 dis2

reg `y' `v' `a', r
local r2_x = e(r2)
x_ols2 gendist_coord1 gendist_coord2 cutoff1 cutoff2 `y' `v' `a' constant, coord(2) xreg(6)
ereturn post beta cov_dep
quiet eststo: ereturn display
estadd scalar r2 = `r2_x'
drop epsilon window dis1 dis2

reg `y' `v' `a' nu_tropical ag_temp du_precavr  ag_elevavg du_oat_rain du_rye_rain, r
local r2_x = e(r2)
x_ols2 gendist_coord1 gendist_coord2 cutoff1 cutoff2 `y' `v' `a' nu_tropical ag_temp du_precavr  ag_elevavg du_oat_rain du_rye_rain constant, coord(2) xreg(12)
ereturn post beta cov_dep
quiet eststo: ereturn display
estadd scalar r2 = `r2_x'
drop epsilon window dis1 dis2

reg `y' `v' `a' nu_tropical ag_temp du_precavr  ag_elevavg du_oat_rain du_rye_rain ag_yst_aa ag_pdiv_aa, r
local r2_x = e(r2)
x_ols2 gendist_coord1 gendist_coord2 cutoff1 cutoff2 `y' `v' `a' nu_tropical ag_temp du_precavr  ag_elevavg du_oat_rain du_rye_rain ag_yst_aa ag_pdiv_aa constant, coord(2) xreg(14)
ereturn post beta cov_dep
quiet eststo: ereturn display
estadd scalar r2 = `r2_x'
drop epsilon window dis1 dis2

reg `y' `v' `a' nu_tropical ag_temp du_precavr  ag_elevavg du_oat_rain du_rye_rain ag_yst_aa ag_pdiv_aa ft_CombinedPa irri_impact4_5 , r
local r2_x = e(r2)
x_ols2 gendist_coord1 gendist_coord2 cutoff1 cutoff2 `y' `v' `a' nu_tropical ag_temp du_precavr  ag_elevavg du_oat_rain du_rye_rain ag_yst_aa ag_pdiv_aa ft_CombinedPa irri_impact4_5 constant, coord(2) xreg(16)
ereturn post beta cov_dep
quiet eststo: ereturn display
estadd scalar r2 = `r2_x'
drop epsilon window dis1 dis2

reg `y' `v' `a' ag_cont_*, r
local r2_x = e(r2)
x_ols2 gendist_coord1 gendist_coord2 cutoff1 cutoff2 `y' `v' `a' ag_cont_* constant, coord(2) xreg(10)
ereturn post beta cov_dep
quiet eststo: ereturn display
estadd scalar r2 = `r2_x'
drop epsilon window dis1 dis2

reg `y' `v' `a' bar_christ bar_MUSLIM00 bar_HINDU00 bar_BUDDIS00, r
local r2_x = e(r2)
x_ols2 gendist_coord1 gendist_coord2 cutoff1 cutoff2 `y' `v' `a' bar_christ bar_MUSLIM00 bar_HINDU00 bar_BUDDIS00 constant, coord(2) xreg(10)
ereturn post beta cov_dep
quiet eststo: ereturn display
estadd scalar r2 = `r2_x'
drop epsilon window dis1 dis2

reg `y' `v' `a' ag_peuro, r
local r2_x = e(r2)
x_ols2 gendist_coord1 gendist_coord2 cutoff1 cutoff2 `y' `v' `a' ag_peuro constant, coord(2) xreg(7)
ereturn post beta cov_dep
quiet eststo: ereturn display
estadd scalar r2 = `r2_x'
drop epsilon window dis1 dis2

esttab using tables\Table1_`v'.rtf, varlabels(__000005 `v') replace star(* 0.10 ** 0.05 *** 0.01) r2 se cells(b(star fmt(2)) se(par fmt(2)))
eststo clear
restore	
}

* Table 1, Panel 4 (Western and Eastern Church exposure)
local y pol_Democracy_1996_2015
local a nu_rugged ag_distcr du_caloricsui ag_abslat
local u ChurchExpWest 
local v ChurchExpEast

preserve
keep if `y'!=. & ChurchExpWest!=. & ChurchExpEast!=. 
reg `y' `u' `v' , r
local r2_x = e(r2)
x_ols2 gendist_coord1 gendist_coord2 cutoff1 cutoff2 `y' `u' `v' constant, coord(2) xreg(3)
ereturn post beta cov_dep
quiet eststo: ereturn display
estadd scalar r2 = `r2_x'
drop epsilon window dis1 dis2

reg `y' `u' `v' `a', r
local r2_x = e(r2)
x_ols2 gendist_coord1 gendist_coord2 cutoff1 cutoff2 `y' `u' `v' `a' constant, coord(2) xreg(7)
ereturn post beta cov_dep
quiet eststo: ereturn display
estadd scalar r2 = `r2_x'
drop epsilon window dis1 dis2

reg `y' `u' `v' `a' nu_tropical ag_temp du_precavr  ag_elevavg du_oat_rain du_rye_rain, r
local r2_x = e(r2)
x_ols2 gendist_coord1 gendist_coord2 cutoff1 cutoff2 `y' `u' `v' `a' nu_tropical ag_temp du_precavr  ag_elevavg du_oat_rain du_rye_rain constant, coord(2) xreg(13)
ereturn post beta cov_dep
quiet eststo: ereturn display
estadd scalar r2 = `r2_x'
drop epsilon window dis1 dis2

reg `y' `u' `v' `a' nu_tropical ag_temp du_precavr  ag_elevavg du_oat_rain du_rye_rain ag_yst_aa ag_pdiv_aa, r
local r2_x = e(r2)
x_ols2 gendist_coord1 gendist_coord2 cutoff1 cutoff2 `y' `u' `v' `a' nu_tropical ag_temp du_precavr  ag_elevavg du_oat_rain du_rye_rain ag_yst_aa ag_pdiv_aa constant, coord(2) xreg(15)
ereturn post beta cov_dep
quiet eststo: ereturn display
estadd scalar r2 = `r2_x'
drop epsilon window dis1 dis2

reg `y' `u' `v' `a' nu_tropical ag_temp du_precavr  ag_elevavg du_oat_rain du_rye_rain ag_yst_aa ag_pdiv_aa ft_CombinedPa irri_impact4_5, r
local r2_x = e(r2)
x_ols2 gendist_coord1 gendist_coord2 cutoff1 cutoff2 `y' `u' `v' `a' nu_tropical ag_temp du_precavr  ag_elevavg du_oat_rain du_rye_rain ag_yst_aa ag_pdiv_aa ft_CombinedPa irri_impact4_5 constant, coord(2) xreg(17)
ereturn post beta cov_dep
quiet eststo: ereturn display
estadd scalar r2 = `r2_x'
drop epsilon window dis1 dis2

reg `y' `u' `v' `a' ag_cont_*, r
local r2_x = e(r2)
x_ols2 gendist_coord1 gendist_coord2 cutoff1 cutoff2 `y' `u' `v' `a' ag_cont_* constant, coord(2) xreg(11)
ereturn post beta cov_dep
quiet eststo: ereturn display
estadd scalar r2 = `r2_x'
drop epsilon window dis1 dis2

reg `y' `u' `v' `a' bar_christ bar_MUSLIM00 bar_HINDU00 bar_BUDDIS00, r
local r2_x = e(r2)
x_ols2 gendist_coord1 gendist_coord2 cutoff1 cutoff2 `y' `u' `v' `a' bar_christ bar_MUSLIM00 bar_HINDU00 bar_BUDDIS00 constant, coord(2) xreg(11)
ereturn post beta cov_dep
quiet eststo: ereturn display
estadd scalar r2 = `r2_x'
drop epsilon window dis1 dis2

reg `y' `u' `v' `a' ag_peuro, r
local r2_x = e(r2)
x_ols2 gendist_coord1 gendist_coord2 cutoff1 cutoff2 `y' `u' `v' `a' ag_peuro constant, coord(2) xreg(8)
ereturn post beta cov_dep
quiet eststo: ereturn display
estadd scalar r2 = `r2_x'
drop epsilon window dis1 dis2

esttab using tables\Table1_Church.rtf, coeflabels(__000005 "`u'" __000006 "`v'") replace star(* 0.10 ** 0.05 *** 0.01) r2 se cells(b(star fmt(2)) se(par fmt(2)))
eststo clear
restore	

*_______________________________________________________________________________
*	Check for multicolinearity if all controls were added simultaneously
local y pol_Democracy_1996_2015
local a nu_rugged ag_distcr du_caloricsui ag_abslat
foreach v of var CousinMarriagePref CousinTermDiff bit_consang_ln { 
preserve
keep if `y'!=. & `v'!=.
reg `y' `v' `a' nu_tropical ag_temp du_precavr  ag_elevavg du_oat_rain du_rye_rain ag_yst_aa ag_pdiv_aa ft_CombinedPa irri_impact4_5 ag_cont_* ag_peuro bar_christ bar_MUSLIM00 bar_HINDU00 bar_BUDDIS00, r
vif
restore	
}
local v ChurchExpWest ChurchExpEast
reg `y' `v' `a' nu_tropical ag_temp du_precavr  ag_elevavg du_oat_rain du_rye_rain ag_yst_aa ag_pdiv_aa ft_CombinedPa irri_impact4_5 ag_cont_* ag_peuro bar_christ bar_MUSLIM00 bar_HINDU00 bar_BUDDIS00, r
vif




*_______________________________________________________________________________
*	Table B1: Kinship and Democracy: Cross-country Evidence with Conley standard errors based on geographic distance
gen const = 1
gen year = 2
gen cellID=3

* Table B1, Panel 1 (cousin marriage preference), Panel 2 (cousin-term differentiation), Panel 3 (log % cousin marriage)
local dist 10000
local y pol_Democracy_1996_2015
local a nu_rugged ag_distcr du_caloricsui ag_abslat

foreach v of var CousinMarriagePref CousinTermDiff bit_consang_ln {
quiet reg `y' `v', r
mat robust_mat1=r(table)
mat robust_mat2=robust_mat1[2,1...]
eststo: acreg `y' `v', spatial latitude(nu_lat) longitude(nu_lon) dist(`dist') bartlett
estadd mat robust_se=robust_mat2

quiet reg `y' `v' `a', r
mat robust_mat1=r(table)
mat robust_mat2=robust_mat1[2,1...]
eststo: acreg `y' `v' `a', spatial latitude(nu_lat) longitude(nu_lon) dist(`dist') bartlett
estadd mat robust_se=robust_mat2

quiet reg `y' `v' `a' nu_tropical ag_temp du_precavr  ag_elevavg du_oat_rain du_rye_rain, r
mat robust_mat1=r(table)
mat robust_mat2=robust_mat1[2,1...]
eststo: acreg `y' `v' `a' nu_tropical ag_temp du_precavr  ag_elevavg du_oat_rain du_rye_rain, spatial latitude(nu_lat) longitude(nu_lon) dist(`dist') bartlett
estadd mat robust_se=robust_mat2

quiet reg `y' `v' `a' nu_tropical ag_temp du_precavr  ag_elevavg du_oat_rain du_rye_rain ag_yst_aa ag_pdiv_aa, r
mat robust_mat1=r(table)
mat robust_mat2=robust_mat1[2,1...]
eststo: acreg `y' `v' `a' nu_tropical ag_temp du_precavr  ag_elevavg du_oat_rain du_rye_rain ag_yst_aa ag_pdiv_aa, spatial latitude(nu_lat) longitude(nu_lon) dist(`dist') bartlett
estadd mat robust_se=robust_mat2

quiet reg `y' `v' `a' nu_tropical ag_temp du_precavr  ag_elevavg du_oat_rain du_rye_rain ag_yst_aa ag_pdiv_aa ft_CombinedPa irri_impact4_5, r
mat robust_mat1=r(table)
mat robust_mat2=robust_mat1[2,1...]
eststo: acreg `y' `v' `a' nu_tropical ag_temp du_precavr  ag_elevavg du_oat_rain du_rye_rain ag_yst_aa ag_pdiv_aa ft_CombinedPa irri_impact4_5, spatial latitude(nu_lat) longitude(nu_lon) dist(`dist') bartlett
estadd mat robust_se=robust_mat2

quiet reg `y' `v' `a' ag_cont_*, r
mat robust_mat1=r(table)
mat robust_mat2=robust_mat1[2,1...]
eststo: acreg `y' `v' `a' ag_cont_*, spatial latitude(nu_lat) longitude(nu_lon) dist(`dist') bartlett
estadd mat robust_se=robust_mat2

quiet reg `y' `v' `a' bar_christ bar_MUSLIM00 bar_HINDU00 bar_BUDDIS00, r
mat robust_mat1=r(table)
mat robust_mat2=robust_mat1[2,1...]
eststo: acreg `y' `v' `a' bar_christ bar_MUSLIM00 bar_HINDU00 bar_BUDDIS00, spatial latitude(nu_lat) longitude(nu_lon) dist(`dist') bartlett
estadd mat robust_se=robust_mat2

quiet reg `y' `v' `a' ag_peuro, r
mat robust_mat1=r(table)
mat robust_mat2=robust_mat1[2,1...]
eststo: acreg `y' `v' `a' ag_peuro, spatial latitude(nu_lat) longitude(nu_lon) dist(`dist') bartlett
estadd mat robust_se=robust_mat2

esttab using tables\TableB1_`v'.rtf, replace star(* 0.10 ** 0.05 *** 0.01) cells(b(star fmt(2)) se(par fmt(2)) robust_se(fmt(2) par(" \right[ " " \left] ")))
eststo clear
}

*Table B1, Panel 4 Church
local dist 10000
local a nu_rugged ag_distcr du_caloricsui ag_abslat
local v ChurchExpWest ChurchExpEast

foreach y of var pol_Democracy_1996_2015 {
quiet reg `y' `v', r
mat robust_mat1=r(table)
mat robust_mat2=robust_mat1[2,1...]
eststo: acreg `y' `v', spatial latitude(nu_lat) longitude(nu_lon) dist(`dist') bartlett
estadd mat robust_se=robust_mat2

quiet reg `y' `v' `a', r
mat robust_mat1=r(table)
mat robust_mat2=robust_mat1[2,1...]
eststo: acreg `y' `v' `a', spatial latitude(nu_lat) longitude(nu_lon) dist(`dist') bartlett
estadd mat robust_se=robust_mat2

quiet reg `y' `v' `a' nu_tropical ag_temp du_precavr  ag_elevavg du_oat_rain du_rye_rain, r
mat robust_mat1=r(table)
mat robust_mat2=robust_mat1[2,1...]
eststo: acreg `y' `v' `a' nu_tropical ag_temp du_precavr  ag_elevavg du_oat_rain du_rye_rain, spatial latitude(nu_lat) longitude(nu_lon) dist(`dist') bartlett
estadd mat robust_se=robust_mat2

quiet reg `y' `v' `a' nu_tropical ag_temp du_precavr  ag_elevavg du_oat_rain du_rye_rain ag_yst_aa ag_pdiv_aa, r
mat robust_mat1=r(table)
mat robust_mat2=robust_mat1[2,1...]
eststo: acreg `y' `v' `a' nu_tropical ag_temp du_precavr  ag_elevavg du_oat_rain du_rye_rain ag_yst_aa ag_pdiv_aa, spatial latitude(nu_lat) longitude(nu_lon) dist(`dist') bartlett
estadd mat robust_se=robust_mat2

quiet reg `y' `v' `a' nu_tropical ag_temp du_precavr  ag_elevavg du_oat_rain du_rye_rain ag_yst_aa ag_pdiv_aa ft_CombinedPa irri_impact4_5, r
mat robust_mat1=r(table)
mat robust_mat2=robust_mat1[2,1...]
eststo: acreg `y' `v' `a' nu_tropical ag_temp du_precavr  ag_elevavg du_oat_rain du_rye_rain ag_yst_aa ag_pdiv_aa ft_CombinedPa irri_impact4_5, spatial latitude(nu_lat) longitude(nu_lon) dist(`dist') bartlett
estadd mat robust_se=robust_mat2

quiet reg `y' `v' `a' ag_cont_*, r
mat robust_mat1=r(table)
mat robust_mat2=robust_mat1[2,1...]
eststo: acreg `y' `v' `a' ag_cont_*, spatial latitude(nu_lat) longitude(nu_lon) dist(`dist') bartlett
estadd mat robust_se=robust_mat2

quiet reg `y' `v' `a' bar_christ bar_MUSLIM00 bar_HINDU00 bar_BUDDIS00, r
mat robust_mat1=r(table)
mat robust_mat2=robust_mat1[2,1...]
eststo: acreg `y' `v' `a' bar_christ bar_MUSLIM00 bar_HINDU00 bar_BUDDIS00, spatial latitude(nu_lat) longitude(nu_lon) dist(`dist') bartlett
estadd mat robust_se=robust_mat2

quiet reg `y' `v' `a' ag_peuro, r
mat robust_mat1=r(table)
mat robust_mat2=robust_mat1[2,1...]
eststo: acreg `y' `v' `a' ag_peuro, spatial latitude(nu_lat) longitude(nu_lon) dist(`dist') bartlett
estadd mat robust_se=robust_mat2

esttab using tables\TableB1_Church.rtf, replace star(* 0.10 ** 0.05 *** 0.01) cells(b(star fmt(2)) se(par fmt(2)) robust_se(fmt(2) par(" \right[ " " \left] ")))
eststo clear
}


*_______________________________________________________________________________
* Table B2:  Local variation in Kinship and Democracy: Cross-country Evidence
*			  Regression controls for the surrounding countries kinship and Church exposure

local y pol_Democracy_1996_2015
local a nu_rugged ag_distcr du_caloricsui ag_abslat

* Table B2, Panel 1: Cousin marriage preferred
local v CousinMarriagePref 
local w close_CousinMarriagePref_2000
preserve
eststo: reg `y' `v' `w', r
eststo: reg `y' `v' `w' `a', r
eststo: reg `y' `v' `w' `a' nu_tropical ag_temp du_precavr  ag_elevavg du_oat_rain du_rye_rain, r
eststo: reg `y' `v' `w' `a' nu_tropical ag_temp du_precavr  ag_elevavg du_oat_rain du_rye_rain ag_yst_aa ag_pdiv_aa, r
eststo: reg `y' `v' `w' `a' nu_tropical ag_temp du_precavr  ag_elevavg du_oat_rain du_rye_rain ag_yst_aa ag_pdiv_aa ft_CombinedPa irri_impact4_5, r
eststo: reg `y' `v' `w' `a' ag_cont_*, r
eststo: reg `y' `v' `w' `a' bar_christ bar_MUSLIM00 bar_HINDU00 bar_BUDDIS00, r
eststo: reg `y' `v' `w' `a' ag_peuro, r
esttab using tables\TableB2_Panel_1_`v'.rtf, replace star(* 0.10 ** 0.05 *** 0.01) r2 se cells(b(star fmt(2)) se(par fmt(2)))
eststo clear
restore	

*Table B2, Panel 2: Cousin-term differentiation
local v CousinTermDiff
local w close_CousinTermDiff_2000
preserve
eststo: reg `y' `v' `w', r
eststo: reg `y' `v' `w' `a', r
eststo: reg `y' `v' `w' `a' nu_tropical ag_temp du_precavr  ag_elevavg du_oat_rain du_rye_rain, r
eststo: reg `y' `v' `w' `a' nu_tropical ag_temp du_precavr  ag_elevavg du_oat_rain du_rye_rain ag_yst_aa ag_pdiv_aa, r
eststo: reg `y' `v' `w' `a' nu_tropical ag_temp du_precavr  ag_elevavg du_oat_rain du_rye_rain ag_yst_aa ag_pdiv_aa ft_CombinedPa irri_impact4_5, r
eststo: reg `y' `v' `w' `a' ag_cont_*, r
eststo: reg `y' `v' `w' `a' bar_christ bar_MUSLIM00 bar_HINDU00 bar_BUDDIS00, r
eststo: reg `y' `v' `w' `a' ag_peuro, r
esttab using tables\TableB2_Panel_2_`v'.rtf, replace star(* 0.10 ** 0.05 *** 0.01) r2 se cells(b(star fmt(2)) se(par fmt(2)))
eststo clear
restore	

*Table B2, Panel 3: Log % cousin marriage
local v bit_consang_ln
local w close_bit_consang_2000_ln
preserve
eststo: reg `y' `v' `w', r
eststo: reg `y' `v' `w' `a', r
eststo: reg `y' `v' `w' `a' nu_tropical ag_temp du_precavr  ag_elevavg du_oat_rain du_rye_rain, r
eststo: reg `y' `v' `w' `a' nu_tropical ag_temp du_precavr  ag_elevavg du_oat_rain du_rye_rain ag_yst_aa ag_pdiv_aa, r
eststo: reg `y' `v' `w' `a' nu_tropical ag_temp du_precavr  ag_elevavg du_oat_rain du_rye_rain ag_yst_aa ag_pdiv_aa ft_CombinedPa irri_impact4_5, r
eststo: reg `y' `v' `w' `a' ag_cont_*, r
eststo: reg `y' `v' `w' `a' bar_christ bar_MUSLIM00 bar_HINDU00 bar_BUDDIS00, r
eststo: reg `y' `v' `w' `a' ag_peuro, r
esttab using tables\TableB2_Panel_3_`v'.rtf, replace star(* 0.10 ** 0.05 *** 0.01) r2 se cells(b(star fmt(2)) se(par fmt(2)))
eststo clear
restore	

*Table B2, Panel 4: Church exposure
local v ChurchExpWest close_ChurchExpWest_2000
local w ChurchExpEast close_ChurchExpEast_2000
preserve
eststo: reg `y' `v' `w', r
eststo: reg `y' `v' `w' `a', r
eststo: reg `y' `v' `w' `a' nu_tropical ag_temp du_precavr  ag_elevavg du_oat_rain du_rye_rain, r
eststo: reg `y' `v' `w' `a' nu_tropical ag_temp du_precavr  ag_elevavg du_oat_rain du_rye_rain ag_yst_aa ag_pdiv_aa, r
eststo: reg `y' `v' `w' `a' nu_tropical ag_temp du_precavr  ag_elevavg du_oat_rain du_rye_rain ag_yst_aa ag_pdiv_aa ft_CombinedPa irri_impact4_5, r
eststo: reg `y' `v' `w' `a' ag_cont_*, r
eststo: reg `y' `v' `w' `a' bar_christ bar_MUSLIM00 bar_HINDU00 bar_BUDDIS00, r
eststo: reg `y' `v' `w' `a' ag_peuro, r
esttab using tables\TableB2_Panel_4_Church_neigh.rtf, replace star(* 0.10 ** 0.05 *** 0.01) r2 se cells(b(star fmt(2)) se(par fmt(2)))
eststo clear
restore	





*________________________________________________________________________________
* Table B3: Kin Networks, GDP per Capita and Democracy: Cross-country Evidence
*			(with Conley standard errors based on genetic distance)

* Table B3, Panel 1 (cousin marriage preference), Panel 2 (cousin-term differentiation), Panel 3 (log % cousin marriage)
local y pol_Democracy_1996_2015
local a nu_rugged ag_distcr du_caloricsui ag_abslat ag_ln_gdppc2000

foreach v of var  CousinMarriagePref CousinTermDiff bit_consang_ln {

preserve
keep if `y'!=. & `v'!=.
reg `y' `v' ag_ln_gdppc2000, r
local r2_x = e(r2)
x_ols2 gendist_coord1 gendist_coord2 cutoff1 cutoff2 `y' `v' ag_ln_gdppc2000 constant, coord(2) xreg(3)
ereturn post beta cov_dep
quiet eststo: ereturn display
estadd scalar r2 = `r2_x'
drop epsilon window dis1 dis2

reg `y' `v' `a', r
local r2_x = e(r2)
x_ols2 gendist_coord1 gendist_coord2 cutoff1 cutoff2 `y' `v' `a' constant, coord(2) xreg(7)
ereturn post beta cov_dep
quiet eststo: ereturn display
estadd scalar r2 = `r2_x'
drop epsilon window dis1 dis2

reg `y' `v' `a' nu_tropical ag_temp du_precavr  ag_elevavg du_oat_rain du_rye_rain, r
local r2_x = e(r2)
x_ols2 gendist_coord1 gendist_coord2 cutoff1 cutoff2 `y' `v' `a' nu_tropical ag_temp du_precavr  ag_elevavg du_oat_rain du_rye_rain constant, coord(2) xreg(13)
ereturn post beta cov_dep
quiet eststo: ereturn display
estadd scalar r2 = `r2_x'
drop epsilon window dis1 dis2

reg `y' `v' `a' nu_tropical ag_temp du_precavr  ag_elevavg du_oat_rain du_rye_rain ag_yst_aa ag_pdiv_aa, r
local r2_x = e(r2)
x_ols2 gendist_coord1 gendist_coord2 cutoff1 cutoff2 `y' `v' `a' nu_tropical ag_temp du_precavr  ag_elevavg du_oat_rain du_rye_rain ag_yst_aa ag_pdiv_aa constant, coord(2) xreg(15)
ereturn post beta cov_dep
quiet eststo: ereturn display
estadd scalar r2 = `r2_x'
drop epsilon window dis1 dis2

reg `y' `v' `a' nu_tropical ag_temp du_precavr  ag_elevavg du_oat_rain du_rye_rain ag_yst_aa ag_pdiv_aa ft_CombinedPa irri_impact4_5, r
local r2_x = e(r2)
x_ols2 gendist_coord1 gendist_coord2 cutoff1 cutoff2 `y' `v' `a' nu_tropical ag_temp du_precavr  ag_elevavg du_oat_rain du_rye_rain ag_yst_aa ag_pdiv_aa ft_CombinedPa irri_impact4_5 constant, coord(2) xreg(17)
ereturn post beta cov_dep
quiet eststo: ereturn display
estadd scalar r2 = `r2_x'
drop epsilon window dis1 dis2

reg `y' `v' `a' ag_cont_*, r
local r2_x = e(r2)
x_ols2 gendist_coord1 gendist_coord2 cutoff1 cutoff2 `y' `v' `a' ag_cont_* constant, coord(2) xreg(11)
ereturn post beta cov_dep
quiet eststo: ereturn display
estadd scalar r2 = `r2_x'
drop epsilon window dis1 dis2

reg `y' `v' `a' bar_christ bar_MUSLIM00 bar_HINDU00 bar_BUDDIS00, r
local r2_x = e(r2)
x_ols2 gendist_coord1 gendist_coord2 cutoff1 cutoff2 `y' `v' `a' bar_christ bar_MUSLIM00 bar_HINDU00 bar_BUDDIS00 constant, coord(2) xreg(11)
ereturn post beta cov_dep
quiet eststo: ereturn display
estadd scalar r2 = `r2_x'
drop epsilon window dis1 dis2

reg `y' `v' `a' ag_peuro, r
local r2_x = e(r2)
x_ols2 gendist_coord1 gendist_coord2 cutoff1 cutoff2 `y' `v' `a' ag_peuro constant, coord(2) xreg(8)
ereturn post beta cov_dep
quiet eststo: ereturn display
estadd scalar r2 = `r2_x'
drop epsilon window dis1 dis2

esttab using tables\TableB3_`v'.rtf, varlabels(__000005 `v')  replace star(* 0.10 ** 0.05 *** 0.01) r2 se cells(b(star fmt(2)) se(par fmt(2)))
eststo clear
restore	
}


*Table B3, Panel 4: Church exposure
local y pol_Democracy_1996_2015
local a nu_rugged ag_distcr du_caloricsui ag_abslat ag_ln_gdppc2000
local v ChurchExpWest ChurchExpEast

preserve
keep if `y'!=. & ChurchExpWest!=. & ChurchExpEast!=. 
reg `y' `v' ag_ln_gdppc2000, r
local r2_x = e(r2)
x_ols2 gendist_coord1 gendist_coord2 cutoff1 cutoff2 `y' `v' ag_ln_gdppc2000 constant, coord(2) xreg(4)
ereturn post beta cov_dep
quiet eststo: ereturn display
estadd scalar r2 = `r2_x'
drop epsilon window dis1 dis2

reg `y' `v' `a', r
local r2_x = e(r2)
x_ols2 gendist_coord1 gendist_coord2 cutoff1 cutoff2 `y' `v' `a' constant, coord(2) xreg(8)
ereturn post beta cov_dep
quiet eststo: ereturn display
estadd scalar r2 = `r2_x'
drop epsilon window dis1 dis2

reg `y' `v' `a' nu_tropical ag_temp du_precavr  ag_elevavg du_oat_rain du_rye_rain, r
local r2_x = e(r2)
x_ols2 gendist_coord1 gendist_coord2 cutoff1 cutoff2 `y' `v' `a' nu_tropical ag_temp du_precavr  ag_elevavg du_oat_rain du_rye_rain constant, coord(2) xreg(14)
ereturn post beta cov_dep
quiet eststo: ereturn display
estadd scalar r2 = `r2_x'
drop epsilon window dis1 dis2

reg `y' `v' `a' nu_tropical ag_temp du_precavr  ag_elevavg du_oat_rain du_rye_rain ag_yst_aa ag_pdiv_aa, r
local r2_x = e(r2)
x_ols2 gendist_coord1 gendist_coord2 cutoff1 cutoff2 `y' `v' `a' nu_tropical ag_temp du_precavr  ag_elevavg du_oat_rain du_rye_rain ag_yst_aa ag_pdiv_aa constant, coord(2) xreg(16)
ereturn post beta cov_dep
quiet eststo: ereturn display
estadd scalar r2 = `r2_x'
drop epsilon window dis1 dis2

reg `y' `v' `a' nu_tropical ag_temp du_precavr  ag_elevavg du_oat_rain du_rye_rain ag_yst_aa ag_pdiv_aa ft_CombinedPa irri_impact4_5, r
local r2_x = e(r2)
x_ols2 gendist_coord1 gendist_coord2 cutoff1 cutoff2 `y' `v' `a' nu_tropical ag_temp du_precavr  ag_elevavg du_oat_rain du_rye_rain ag_yst_aa ag_pdiv_aa ft_CombinedPa irri_impact4_5 constant, coord(2) xreg(18)
ereturn post beta cov_dep
quiet eststo: ereturn display
estadd scalar r2 = `r2_x'
drop epsilon window dis1 dis2

reg `y' `v' `a' ag_cont_*, r
local r2_x = e(r2)
x_ols2 gendist_coord1 gendist_coord2 cutoff1 cutoff2 `y' `v' `a' ag_cont_* constant, coord(2) xreg(12)
ereturn post beta cov_dep
quiet eststo: ereturn display
estadd scalar r2 = `r2_x'
drop epsilon window dis1 dis2

reg `y' `v' `a' bar_christ bar_MUSLIM00 bar_HINDU00 bar_BUDDIS00, r
local r2_x = e(r2)
x_ols2 gendist_coord1 gendist_coord2 cutoff1 cutoff2 `y' `v' `a' bar_christ bar_MUSLIM00 bar_HINDU00 bar_BUDDIS00 constant, coord(2) xreg(12)
ereturn post beta cov_dep
quiet eststo: ereturn display
estadd scalar r2 = `r2_x'
drop epsilon window dis1 dis2

reg `y' `v' `a' ag_peuro, r
local r2_x = e(r2)
x_ols2 gendist_coord1 gendist_coord2 cutoff1 cutoff2 `y' `v' `a' ag_peuro constant, coord(2) xreg(9)
ereturn post beta cov_dep
quiet eststo: ereturn display
estadd scalar r2 = `r2_x'
drop epsilon window dis1 dis2

esttab using tables\TableB3_Church.rtf, replace star(* 0.10 ** 0.05 *** 0.01) r2 se cells(b(star fmt(2)) se(par fmt(2)))
eststo clear
restore	






*_______________________________________________________________________________
*	Table B4: Country-level Medieval Church exposure and kin networks 

* Table B4, Panel 1 (cousin marriage preference), Panel 2 (cousin-term differentiation), Panel 3 (log % cousin marriage)
local v ChurchExpWest ChurchExpEast
local a nu_rugged ag_distcr du_caloricsui ag_abslat

foreach y of var CousinMarriagePref CousinTermDiff bit_consang_ln { 

preserve
keep if `y'!=. & ChurchExpWest!=. & ChurchExpEast!=.
reg `y' `v' , r
local r2_x = e(r2)
x_ols2 gendist_coord1 gendist_coord2 cutoff1 cutoff2 `y' `v' constant, coord(2) xreg(3)
ereturn post beta cov_dep
quiet eststo: ereturn display
estadd scalar r2 = `r2_x'
drop epsilon window dis1 dis2

reg `y' `v' `a', r
local r2_x = e(r2)
x_ols2 gendist_coord1 gendist_coord2 cutoff1 cutoff2 `y' `v' `a' constant, coord(2) xreg(7)
ereturn post beta cov_dep
quiet eststo: ereturn display
estadd scalar r2 = `r2_x'
drop epsilon window dis1 dis2

reg `y' `v' `a' nu_tropical ag_temp du_precavr  ag_elevavg du_oat_rain du_rye_rain, r
local r2_x = e(r2)
x_ols2 gendist_coord1 gendist_coord2 cutoff1 cutoff2 `y' `v' `a' nu_tropical ag_temp du_precavr  ag_elevavg du_oat_rain du_rye_rain constant, coord(2) xreg(13)
ereturn post beta cov_dep
quiet eststo: ereturn display
estadd scalar r2 = `r2_x'
drop epsilon window dis1 dis2

reg `y' `v' `a' nu_tropical ag_temp du_precavr  ag_elevavg du_oat_rain du_rye_rain ag_yst_aa ag_pdiv_aa, r
local r2_x = e(r2)
x_ols2 gendist_coord1 gendist_coord2 cutoff1 cutoff2 `y' `v' `a' nu_tropical ag_temp du_precavr  ag_elevavg du_oat_rain du_rye_rain ag_yst_aa ag_pdiv_aa constant, coord(2) xreg(15)
ereturn post beta cov_dep
quiet eststo: ereturn display
estadd scalar r2 = `r2_x'
drop epsilon window dis1 dis2

reg `y' `v' `a' nu_tropical ag_temp du_precavr  ag_elevavg du_oat_rain du_rye_rain ag_yst_aa ag_pdiv_aa ft_CombinedPa irri_impact4_5, r
local r2_x = e(r2)
x_ols2 gendist_coord1 gendist_coord2 cutoff1 cutoff2 `y' `v' `a' nu_tropical ag_temp du_precavr  ag_elevavg du_oat_rain du_rye_rain ag_yst_aa ag_pdiv_aa ft_CombinedPa irri_impact4_5 constant, coord(2) xreg(17)
ereturn post beta cov_dep
quiet eststo: ereturn display
estadd scalar r2 = `r2_x'
drop epsilon window dis1 dis2

reg `y' `v' `a' ag_cont_*, r
local r2_x = e(r2)
x_ols2 gendist_coord1 gendist_coord2 cutoff1 cutoff2 `y' `v' `a' ag_cont_* nu_tropical ag_temp du_precavr  ag_elevavg du_oat_rain du_rye_rain ag_yst_aa ag_pdiv_aa ft_CombinedPa irri_impact4_5 constant, coord(2) xreg(21)
ereturn post beta cov_dep
quiet eststo: ereturn display
estadd scalar r2 = `r2_x'
drop epsilon window dis1 dis2

reg `y' `v' `a' bar_christ bar_MUSLIM00 bar_HINDU00 bar_BUDDIS00, r
local r2_x = e(r2)
x_ols2 gendist_coord1 gendist_coord2 cutoff1 cutoff2 `y' `v' `a' bar_christ bar_MUSLIM00 bar_HINDU00 bar_BUDDIS00 constant, coord(2) xreg(11)
ereturn post beta cov_dep
quiet eststo: ereturn display
estadd scalar r2 = `r2_x'
drop epsilon window dis1 dis2

esttab using tables\TableB4_`y'.rtf, replace star(* 0.10 ** 0.05 *** 0.01) r2 se cells(b(star fmt(2)) se(par fmt(2)))
eststo clear
restore	
}





